local t = Def.ActorFrame {};
local iIndex = Var("GameCommand"):GetIndex();
local iText = Var("GameCommand"):GetText();

-- Item Sector
t[#t+1] = LoadActor(THEME:GetPathG("MusicWheelItem SectionCollapsed", "NormalPart")) .. {
	InitCommand=cmd(x,SCREEN_LEFT-14-18;y,SCREEN_TOP+80+(iIndex*THEME:GetMetric("MusicWheel","ItemSpacingY")));
	OnCommand=cmd(horizalign,right;rotationy,180);
	GainFocusCommand=cmd(finishtweening;spring,0.3;addx,10);
	LoseFocusCommand=cmd(finishtweening;spring,0.3;addx,-10);
};	
-- Title 
t[#t+1] = LoadFont("Common Normal") .. {
	Text=iText;
	InitCommand=cmd(x,SCREEN_LEFT+7;y,SCREEN_TOP+80+(iIndex*THEME:GetMetric("MusicWheel","ItemSpacingY")));
	OnCommand=cmd(horizalign,left;NoStroke;shadowlength,1;diffuse,cBlue;);
	GainFocusCommand=cmd(finishtweening;diffuse,LightColor(cOrange);diffusebottomedge,cOrange);
	LoseFocusCommand=cmd(stoptweening;decelerate,0.3;diffuse,cBlue;);
};

local function CreatePreference(pref,name)
	local width = 180;
	return Def.ActorFrame {
		LoadFont("Common Normal") .. {
			Text=name;
			InitCommand=cmd(horizalign,left;x,-width;zoom,0.5);
			OnCommand=cmd(NoStroke;shadowlength,1);
		};
		Def.Quad {
			InitCommand=cmd(y,8;fadeleft,1;x,-width/2;zoomto,width,1);
		};
		LoadFont("Common Normal") .. {
			Text=tostring(PREFSMAN:GetPreference(pref));
			InitCommand=cmd(horizalign,right;zoom,0.75;y,18);
			OnCommand=cmd(NoStroke;shadowlength,1);
		};
	};
end

-- Preferences to show --

local i = Def.ActorFrame {
	GainFocusCommand=cmd(visible,true);
	LoseFocusCommand=cmd(visible,false);
};

if iText == "Appearance Options" then
	i[#i+1] = CreatePreference("Language","Language") .. {
		InitCommand=cmd(x,SCREEN_RIGHT;y,SCREEN_TOP+80+(0*30));
	};		
	i[#i+1] = CreatePreference("ShowInstructions","Show Instructions") .. {
		InitCommand=cmd(x,SCREEN_RIGHT;y,SCREEN_TOP+80+(1*30));
	};	
	i[#i+1] = CreatePreference("ShowCaution","Show Cautions") .. {
		InitCommand=cmd(x,SCREEN_RIGHT;y,SCREEN_TOP+80+(2*30));
	};	
	i[#i+1] = CreatePreference("BGBrightness","BG Brightness") .. {
		InitCommand=cmd(x,SCREEN_RIGHT;y,SCREEN_TOP+80+(3*30));
	};	
	i[#i+1] = CreatePreference("ShowDanger","Danger Background") .. {
		InitCommand=cmd(x,SCREEN_RIGHT;y,SCREEN_TOP+80+(4*30));
	};	
	i[#i+1] = CreatePreference("Theme","Current Theme") .. {
		InitCommand=cmd(x,SCREEN_RIGHT;y,SCREEN_TOP+80+(5*30));
	};	
end

if iText == "Graphic/Sound Options" then
	i[#i+1] = CreatePreference("Language","Language") .. {
		InitCommand=cmd(x,SCREEN_RIGHT;y,SCREEN_TOP+80+(0*30));
	};	
end




-- Finished Table --

local z = Def.ActorFrame {};

z[#z+1] = t;
z[#z+1] = i;

return z